<?php
/**
 * @version		1.2
 * @package		Joomla
 * @subpackage	Event Booking
 * @author  Hugues HERVE - Mathalis Web Studio
 * @copyright	Copyright (C) 2013 Mathalis Web Studio
 * @license		GNU/GPL, see LICENSE.php
 */

header("Pragma: no-cache");
header("Content-type: text/plain");

// BEGIN - Joomla loading

$mypath = dirname(__FILE__);

define( '_JEXEC', 1 );
define( 'DS', DIRECTORY_SEPARATOR );
define('JPATH_BASE', dirname($mypath."/../../../."));

require_once ( JPATH_BASE .DS.'includes'.DS.'defines.php' );
require_once ( JPATH_BASE .DS.'includes'.DS.'framework.php' );
require_once ( JPATH_BASE .DS.'components'.DS.'com_eventbooking'.DS.'helper'.DS.'helper.php');
require_once ( JPATH_BASE .DS.'components'.DS.'com_eventbooking'.DS.'helper'.DS.'fields.php');
$mainframe =& JFactory::getApplication('site');
JPluginHelper::importPlugin('system');
JPluginHelper::importPlugin('eventbooking');


$mainframe->initialise();
// END - Joomla loading

$controle = '/homez.221/mathalis/www/coachfede/components/com_eventbooking/payments/returncode.txt';


// TPE Settings
// Warning !! CMCIC_Config contains the key, you have to protect this file with all the mechanism available in your development environment.
// You may for instance put this file in another directory and/or change its name. If so, don't forget to adapt the include path below.
require_once("os_cmcic_Config.php");

// --- PHP implementation of RFC2104 hmac sha1 ---
require_once("os_cmcic_Tpe.inc.php");


// Begin Main : Retrieve Variables posted by CMCIC Payment Server 
$CMCIC_bruteVars = getMethode();

// TPE init variables
$oTpe = new CMCIC_Tpe();
$oHmac = new CMCIC_Hmac($oTpe);

// Clean Texte-libre string 
if ( isset( $CMCIC_bruteVars['texte-libre'] ) ) {
	$CMCIC_bruteVars['texte-libre']	=	stripslashes( $CMCIC_bruteVars['texte-libre'] );
}

// Message Authentication
$cgi2_fields = sprintf(CMCIC_CGI2_FIELDS, 
					  $oTpe->sNumero,
					  $CMCIC_bruteVars["date"],
				      $CMCIC_bruteVars['montant'],
				      $CMCIC_bruteVars['reference'],
				      $CMCIC_bruteVars['texte-libre'],
					  $oTpe->sVersion,
				      $CMCIC_bruteVars['code-retour'],
					  $CMCIC_bruteVars['cvx'],
					  $CMCIC_bruteVars['vld'],
					  $CMCIC_bruteVars['brand'],
					  $CMCIC_bruteVars['status3ds'],
					  $CMCIC_bruteVars['numauto'],
					  $CMCIC_bruteVars['motifrefus'],
					  $CMCIC_bruteVars['originecb'],
					  $CMCIC_bruteVars['bincb'],
					  $CMCIC_bruteVars['hpancb'],
					  $CMCIC_bruteVars['ipclient'],
					  $CMCIC_bruteVars['originetr'],
					  $CMCIC_bruteVars['veres'],
					  $CMCIC_bruteVars['pares']
					);

if ($oHmac->computeHmac($cgi2_fields) == strtolower($CMCIC_bruteVars['MAC']))
	{
	switch($CMCIC_bruteVars['code-retour']) {
		case "Annulation" :
			// Payment has been refused
			// put your code here (email sending / Database update)
			// Attention : an autorization may still be delivered for this payment
			// HH BEGIN - DEBUG
			break;

		case "payetest":
			// Payment has been accepeted on the test server
			// put your code here (email sending / Database update)
			
			// HH  BEGIN : Get event id to update with registration code return by bank
			$db = JFactory::getDbo();
			$event = $db->getQuery(true);
			$event->select('*');
			$event->from('#__eb_registrants');
 			$event->where('transaction_id = "'.$CMCIC_bruteVars['reference'].'"');
 			$db->setQuery($event);
 			$event_id = $db->loadResult();
 			
			 			
 			// Update record to Publish 
  			$db_update = JFactory::getDbo();
 			$eventToUpdate = $db_update->getQuery(true);
 			$eventToUpdate->update('#__eb_registrants');
 			$eventToUpdate->set('transaction_id ="'.$CMCIC_bruteVars['reference'].'"'); 			
 			$eventToUpdate->set('payment_date = "'.date('Y-m-d H:i:s').'"');
 			$eventToUpdate->set('published = "1"');
 			$eventToUpdate->where('registration_code = "'.$CMCIC_bruteVars['reference'].'"');
 			$db_update->setQuery($eventToUpdate);
 			$result=$db_update->query();
 			 			
 			// Init registrant's data
 			$db = JFactory::getDbo();
 			$event = $db->getQuery(true);
 			$event->select('*');
 			$event->from('#__eb_registrants');
 			$event->where('transaction_id = "'.$CMCIC_bruteVars['reference'].'"');
 			$db->setQuery($event);
 			
 			// Group billing process 
 			if ($row->is_group_billing)
 			{
 				EventBookingHelper::updateGroupRegistrationRecord($row->id);
 			}
 			
 			// Send Email
 			JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_eventbooking'.DS.'tables');
 			$config = EventBookingHelper::getConfig();
 			$row = JTable::getInstance('EventBooking', 'Registrant');
 			$row->load($eventId); 			
 			
//  sendEmails fail to send emails : I DONT KNOW HOW TO LOAD AL WHAT WE NEED 		
 			EventBookingHelper::sendEmails($row, $config); 			
 			
			// Trigger onAfterPaymentSuccess proccessing
			$dispatcher = JDispatcher::getInstance();
			$dispatcher->trigger('onAfterPaymentSuccess', array($row));
			break;

		case "paiement":
			// Payment has been accepted on the productive server
			// put your code here (email sending / Database update)
			// HH  BEGIN : Get event id to update with registration code return by bank
			break;
			
		/*** ONLY FOR MULTIPART PAYMENT ***/
		case "paiement_pf2":
		case "paiement_pf3":
		case "paiement_pf4":
			// Payment has been accepted on the productive server for the part #N
			// return code is like paiement_pf[#N]
			// put your code here (email sending / Database update)
			// You have the amount of the payment part in $CMCIC_bruteVars['montantech']
			break;

		case "Annulation_pf2":
		case "Annulation_pf3":
		case "Annulation_pf4":
			// Payment has been refused on the productive server for the part #N
			// return code is like Annulation_pf[#N]
			// put your code here (email sending / Database update)
			// You have the amount of the payment part in $CMCIC_bruteVars['montantech']
			break;
			
	}

	$receipt = CMCIC_CGI2_MACOK;

}
else
{
	// your code if the HMAC doesn't match
	$receipt = CMCIC_CGI2_MACNOTOK.$cgi2_fields;
}

//-----------------------------------------------------------------------------
// Send receipt to CMCIC server
//-----------------------------------------------------------------------------
// HH BEGIN - DEBUG
$fp = fopen($controle, 'a');
fwrite($fp, "\n".$CMCIC_bruteVars['date']." --- BEGIN URL RETOUR ->");
fwrite($fp, $CMCIC_bruteVars['code-retour']);
foreach ( $CMCIC_bruteVars as $key => $value )
{
	fwrite($fp, "\n".$key." -> ".$value);
}
fwrite($fp, "\n".$CMCIC_bruteVars['date']." --- END URL RETOUR");
fclose($fp); // close file
// HH END - DEBUG

printf (CMCIC_CGI2_RECEIPT, $receipt);


// Copyright (c) 2009 Euro-Information ( mailto:centrecom@e-i.com )
// All rights reserved. ---
?>
