<?php
/**
 * @version		1.6.3
 * @package		Joomla
 * @subpackage	Event Booking
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 - 2013 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// no direct access
defined('_JEXEC') or die();

/**
 * HTML View class for the Event Booking component
 *
 * @static
 * @package		Joomla
 * @subpackage	EventBooking
 */
class EventBookingViewComplete extends JViewLegacy
{

	function display($tpl = null)
	{
		$this->setLayout('default'); //Hardcoded the layout, it happens with some clients. Maybe it is a bug of Joomla core code, will find out it later
		$db = JFactory::getDbo();
		$config = EventbookingHelper::getConfig();
		$registrationCode = JRequest::getVar('registration_code');
		if ($registrationCode)
		{
			$sql = 'SELECT id FROM #__eb_registrants WHERE registration_code="' . $registrationCode . '" ORDER BY id LIMIT 1 ';
			$db->setQuery($sql);
			$id = (int) $db->loadResult();
		}
		else
		{
			JFactory::getApplication()->redirect('index.php', JText::_('EB_INVALID_REGISTRATION_CODE'));
		}

        if (!$id)
        {
            JFactory::getApplication()->redirect('index.php', JText::_('EB_INVALID_REGISTRATION_CODE'));
        }

		$sql = 'SELECT a.id, a.title, a.currency_symbol, a.thanks_message, a.thanks_message_offline, b.payment_method FROM #__eb_events  AS a ' .
			 ' INNER JOIN #__eb_registrants AS b ' . ' ON a.id = b.event_id ' . ' WHERE b.id = ' . $id;
		$db->setQuery($sql);
		$registrant = $db->loadObject();
		
		
		//Redirect back to the individual registration page
		if ($config->use_https)
		{
			$ssl = true ;
		}
		else
		{
			$ssl = false ;
		}
		$url = JRoute::_('index.php?option=com_eventbooking&task=individual_registration&event_id='.$registrant->id.'&Itemid='.JRequest::getInt('Itemid'), false, $ssl) ;		
		JFactory::getApplication()->redirect($url);		
		$message = EventbookingHelper::getMessages();
		$fieldSuffix = EventbookingHelper::getFieldSuffix();		
		//Override thanks message
		if (strlen(trim(strip_tags($registrant->thanks_message))))
		{
			$config->thanks_message = $registrant->thanks_message;
		}
		if (strlen(trim(strip_tags($registrant->thanks_message_offline))))
		{
			$config->thanks_message_offline = $registrant->thanks_message_offline;
		}
		if (strpos($registrant->payment_method, 'os_offline') !== false)
		{			
			if (strlen(trim(strip_tags($registrant->thanks_message_offline))))
			{
				$thankMessage = $registrant->thanks_message_offline;
			}
			elseif (strlen(trim(strip_tags($message->{'thanks_message_offline'.$fieldSuffix}))))
			{
				$thankMessage = $message->{'thanks_message_offline'.$fieldSuffix};
			}
			else 
			{
				$thankMessage = $message->thanks_message_offline;				
			}			
		}
		else
		{			
			if (strlen(trim(strip_tags($registrant->thanks_message))))
			{
				$thankMessage = $registrant->thanks_message;
			}
			elseif (strlen(trim(strip_tags($message->{'thanks_message'.$fieldSuffix}))))
			{
				$thankMessage = $message->{'thanks_message'.$fieldSuffix};
			}
			else
			{
				$thankMessage = $message->thanks_message;
			}			
		}
        $sql = 'SELECT * FROM #__eb_registrants WHERE id=' . $id;
        $db->setQuery($sql);
        $row = $db->loadObject();
        $replaces = array();
        $replaces['first_name'] = $row->first_name;
        $replaces['last_name'] = $row->last_name;
        $replaces['organization'] = $row->organization;
        $replaces['address'] = $row->address;
        $replaces['address2'] = $row->address;
        $replaces['city'] = $row->city;
        $replaces['state'] = $row->state;
        $replaces['zip'] = $row->zip;
        $replaces['country'] = $row->country;
        $replaces['phone'] = $row->phone;
        $replaces['fax'] = $row->phone;
        $replaces['email'] = $row->email;
        $replaces['comment'] = $row->comment;
        $replaces['REGISTRATION_DETAIL'] = EventbookingHelper::getEmailContent($config, $row, false);
		if ($config->multiple_booking)
		{
			$sql = 'SELECT event_id FROM #__eb_registrants WHERE id=' . $id . ' OR cart_id=' . $id . ' ORDER BY id';
			$db->setQuery($sql);
			$eventIds = $db->loadColumn();			
			$sql = 'SELECT title FROM #__eb_events WHERE id IN (' . implode(',', $eventIds) . ') ORDER BY FIND_IN_SET(id, "' . implode(',', $eventIds) .
				 '")';
			$db->setQuery($sql);			
			$eventTitles = $db->loadColumn();			
			$eventTitle = implode(', ', $eventTitles);
			$thankMessage = str_replace('[EVENT_TITLE]', $eventTitle, $thankMessage);
            //Amount calculation
            $sql = 'SELECT SUM(total_amount) FROM #__eb_registrants WHERE id=' . $row->id . ' OR cart_id=' . $row->id;
            $db->setQuery($sql);
            $totalAmount = $db->loadResult();

            $sql = 'SELECT SUM(tax_amount) FROM #__eb_registrants WHERE id=' . $row->id . ' OR cart_id=' . $row->id;
            $db->setQuery($sql);
            $taxAmount = $db->loadResult();

            $sql = 'SELECT SUM(discount_amount) FROM #__eb_registrants WHERE id=' . $row->id . ' OR cart_id=' . $row->id;
            $db->setQuery($sql);
            $discountAmount = $db->loadResult();
            $amount = $totalAmount - $discountAmount;

            $replaces['total_amount'] = EventbookingHelper::formatCurrency($totalAmount, $config, $registrant->currency_symbol);
            $replaces['tax_amount'] = EventbookingHelper::formatCurrency($taxAmount, $config, $registrant->currency_symbol);
            $replaces['amount'] = EventbookingHelper::formatCurrency($amount, $config, $registrant->currency_symbol);
		}
		else
		{
			$thankMessage = str_replace('[EVENT_TITLE]', $registrant->title, $thankMessage);
            $replaces['amount'] = EventbookingHelper::formatCurrency($row->amount, $config, $registrant->currency_symbol);
		}
		foreach ($replaces as $key => $value)
		{
			$key = strtoupper($key);
			$thankMessage = str_replace("[$key]", $value, $thankMessage);
		}
		$this->message = $thankMessage;

		parent::display($tpl);
	}
}