<?php
/**
 * @version        1.1.1
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use OSSolution\HelpdeskPro\Site\Helper\Helper;

class getTicketsHistoryTab extends cbTabHandler
{
	/**
	 * Constructor
	 */
	public function __construct()
	{
		$this->cbTabHandler();
	}

	/**
	 * Display tickets history of a user
	 *
	 * @param object $tab
	 * @param object $user
	 * @param int    $ui
	 *
	 * @return string
	 */
	public function getDisplayTab($tab, $user, $ui)
	{
		$params = $this->params;

		/* @var \Joomla\Database\DatabaseDriver $db */
		$db    = Factory::getContainer()->get('db');
		$query = $db->getQuery(true);
		$query->select('COUNT(*)')
			->from('#__helpdeskpro_tickets')
			->where('user_id = ' . $user->id);
		$db->setQuery($query);
		$total = $db->loadResult();

		$numberTickets = $params->get('number_records', 10);
		$pagingParams  = $this->_getPaging(array(), array("entries_"));

		if ($pagingParams["entries_limitstart"] === null)
		{
			$pagingParams["entries_limitstart"] = "0";
		}

		if ($numberTickets > $total)
		{
			$pagingParams["entries_limitstart"] = "0";
		}

		$query->clear()
			->select('a.*, b.title AS category_name, c.title AS status_name, d.title AS priority_name')
			->from('#__helpdeskpro_tickets AS a')
			->innerJoin('#__helpdeskpro_categories AS b ON a.category_id = b.id')
			->innerJoin('#__helpdeskpro_statuses AS c ON a.status_id = c.id')
			->innerJoin('#__helpdeskpro_priorities AS d ON a.priority_id = d.id')
			->where('user_id = '. $user->id)
			->order('a.modified_date DESC');

		$limitStart = $pagingParams["entries_limitstart"] ?: 0;
		$db->setQuery($query, $limitStart, $numberTickets);
		$rows = $db->loadObjectList();

		ob_start();

		$this->drawTicketsHistory($rows, $pagingParams, $numberTickets, $total);

		return ob_get_clean();
	}

	/**
	 * Draw the output for donation history
	 *
	 * @param array $rows
	 */
	private function drawTicketsHistory($rows, $pagingParams, $numberTickets, $total)
	{
		// Bootstrap the component libraries
		require_once JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/init.php';

		// Get component config data
		$config = require JPATH_ADMINISTRATOR . '/components/com_helpdeskpro/config.php';

		// Creating component container for autoloading
		$container = OSL\Container\Container::getInstance('com_helpdeskpro', $config);

		// Load component language
		Helper::loadLanguage();

		$config     = Helper::getConfig();
		$Itemid     = Helper::getItemid();
		$dateFormat = $config->date_format;

		if (count($rows))
		{
			?>
			<table class="table table-striped table-bordered table-condensed">
				<thead>
				<tr>
					<th>
						<?php echo Text::_('HDP_TITLE'); ?>
					</th>
					<th>
						<?php echo Text::_('HDP_CATEGORY'); ?>
					</th>
					<th class="center">
						<?php echo Text::_('HDP_CREATED_DATE'); ?>
					</th>
					<th>
						<?php echo Text::_('HDP_MODIFIED_DATE'); ?>
					</th>
					<th>
						<?php echo Text::_('HDP_STATUS'); ?>
					</th>
					<th width="2%">
						<?php echo Text::_('HDP_ID'); ?>
					</th>
				</tr>
				</thead>
				<tbody>
				<?php
				$k    = 0;
				for ($i = 0, $n = count($rows); $i < $n; $i++)
				{
					$row = $rows[$i];
					?>
					<tr class="row<?php echo $k; ?>">
						<td>
							<a href="<?php echo JRoute::_('index.php?option=com_helpdeskpro&view=ticket&layout=default&id=' . $row->id . '&Itemid=' . $Itemid); ?>"><?php echo $row->subject; ?></a>
						</td>
						<td align="center">
							<?php echo $row->category_name; ?>
						</td>
						<td>
							<?php echo HTMLHelper::_('date', $row->created_date, $dateFormat); ?>
						</td>
						<td align="right">
							<?php echo HTMLHelper::_('date', $row->modified_date, $dateFormat); ?>
						</td>
						<td align="center">
							<?php echo $row->status_name; ?>
						</td>
						<td align="center">
							<?php echo $row->id; ?>
						</td>
					</tr>
					<?php
					$k = 1 - $k;
				}
				?>
				</tbody>
				<?php
				if ($total > $numberTickets)
				{
					?>
					<tfoot>
					<tr>
						<td colspan="6">
							<div class="pagination"><?php echo $this->_writePaging($pagingParams, "entries_", $numberTickets, $total); ?></div>
						</td>
					</tr>
					</tfoot>
					<?php
				}
				?>
			</table>
			<?php
		}
		else
		{
			echo Text::_('HDP_DO_NOT_HAVE_TICKETS');
		}
	}
}
