<?php
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }
class getEBRegistrationHistoryTab  extends cbTabHandler {
	/**
	* Constructor
	*/
	function getEBRegistrationHistoryTab() {
		$this->cbTabHandler();
	}
	/**
	 * Display registration history of a user
	 *
	 * @param object $tab
	 * @param object $user
	 * @param int $ui
	 */
	function getDisplayTab($tab,$user,$ui) {
		$db = & JFactory::getDBO() ;
		$params = $this->params ;		
		$sql = 'SELECT COUNT(*) FROM #__eb_registrants WHERE (published = 1 OR (payment_method = "os_offline" AND published !=2 )) AND user_id = '.$user->id;
		$db->setQuery($sql) ;
		$total = $db->loadResult();		
		$numberRegistrants = $params->get('number_records', 10);			
		$pagingParams = $this->_getPaging(array(),array("entries_"));
		if ($pagingParams["entries_limitstart"] === null) $pagingParams["entries_limitstart"] = "0";
		if ($numberRegistrants > $total) $pagingParams["entries_limitstart"] = "0";		
		$sql=" SELECT a.*, b.title AS event_title FROM #__eb_registrants AS a INNER JOIN #__eb_events AS b ON a.event_id=b.id WHERE (a.published = 1 OR (a.payment_method = 'os_offline' AND a.published != 2)) AND a.user_id=$user->id "
			. " Order by a.id DESC "			
			. "\n LIMIT ".($pagingParams["entries_limitstart"]?$pagingParams["entries_limitstart"]:"0").",".$numberRegistrants;
		;
		$db->setQuery($sql) ;
		$rows = $db->loadObjectList();		
		//Get currency symbol
		$sql = 'SELECT config_value FROM #__eb_configs WHERE config_key="currency_symbol"';
		$db->setQuery($sql);
		$currencySymbol = $db->loadResult();	
		ob_start();
		$this->_drawRegistrationHistory($rows, $currencySymbol, $pagingParams, $numberRegistrants, $total);
		$return = ob_get_contents();
		ob_end_clean();
		return $return;
	}

	/**
	 * Draw the output for donation history
	 *
	 * @param array $rows
	 */
	function _drawRegistrationHistory($rows , $symbol, $pagingParams, $numberRegistrants, $total) {
		//Load language file here
		require_once (JPATH_ROOT.DS.'components'.DS.'com_eventbooking'.DS.'helper'.DS.'helper.php');
		$dateFormat = EventBookingHelper::getConfigValue('date_format') ;
		$itemId = EventBookingHelper::getItemid() ;
		EventBookingHelper::loadLanguage();		
		if (count($rows)) {
		?>
			<table width="100%" cellspacing="3" cellpadding="3" class="eb_registration_history">
				<tr>
					<td class="sectiontableheader">
						<?php echo JText::_('EB_NO'); ?>
					</td>
					<td class="sectiontableheader">
						<?php echo JText::_('EB_EVENT') ; ?>
					</td>
					<td class="sectiontableheader" align="center">
						<?php echo JText::_('EB_NUMBER_REGISTRANTS') ; ?>
					</td>					
					<td class="sectiontableheader">
						<?php echo JText::_('EB_REGISTRATION_DATE') ; ?>
					</td>
					<td class="sectiontableheader" align="right">
						<?php echo JText::_('EB_AMOUNT').' ('.$symbol.')';?>
					</td>									
				</tr>
				<?php
					$tabs = array('sectiontableentry1', 'sectiontableentry2');
					$k = 0;
					for($i=0, $n = count($rows); $i < $n; $i++) {
						$row = $rows[$i];
						$tab = $tabs[$k];
					?>
					<tr class="<?php echo $tab; ?>">
						<td>
							<?php echo ($i + 1); ?>
						</td>
						<td>
							<a href="<?php echo JRoute::_('index.php?option=com_eventbooking&task=view_event&event_id='.$row->event_id.'&Itemid='.$itemId); ?>"><?php echo $row->event_title ; ?></a>
						</td>
						<td align="center">
							<?php echo $row->number_registrants ; ?>
						</td>						
						<td>
							<?php echo JHTML::_('date', $row->register_date, $dateFormat); ?>
						</td>
						<td align="right">
							<?php echo  number_format($row->amount, 2); ?>					
						</td>						
					</tr>
					<?php	
						$k =  1 - $k;	
					}					
					if ($total > $numberRegistrants) {
					?>
						<tr>
							<td colspan="5">
								<div align="center"><?php echo $this->_writePaging($pagingParams ,"entries_", $numberRegistrants, $total);  ?></div>
							</td>
						</tr>
					<?php	
					}
				?>												
			</table>
		<?php	
		}		
	}
}
?>
