<?php
/**
 * @version		1.0
 * @package		Joomla
 * @subpackage	Joom Donation
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
class os_fddirect extends os_payment {		
	/**
	 * Array of params will be posted to server
	 *
	 * @var string
	 */
	var $_params = array();	
	/**
	 * Constructor functions, init some parameter
	 *
	 * @param object $config
	 */
	function os_fddirect($params) {
		parent::setName('os_fddirect');
		parent::os_payment();						
		parent::setCreditCard(true);		
	    parent::setCardType(true);
	    parent::setCardCvv(true);
	    parent::setCardHolderName(true);						
		$this->setParam('host', 'secure.linkpt.net') ;
		$this->setParam('port', '1129') ;
		$this->setParam('ordertype', 'SALE') ;
		$this->setParam('cvmindicator', 'provided') ;
		if ($params->get('fddirect_mode', 0)) {
			$this->setParam('result', 'LIVE') ;
		} else {
			$this->setParam('result', 'GOOD') ;
		}
		$this->setParam('configfile', $params->get('store_number'));
		$this->setParam('keyfile', JPATH_COMPONENT.DS.'payments'.DS.'fddirect'.DS.'PEMFILE.pem') ;							
	}	
	
	function getEnableRecurring() {
		return 1 ;
	}
	/**
	 * Set param value
	 *
	 * @param string $name
	 * @param string $val
	 */
	function setParam($name, $val) {
		$this->_params[$name] = $val;
	}
	/**
	 * Setup payment parameter
	 *
	 * @param array $params
	 */
	function setParams($params) {
		foreach ($params as $key => $value) {
			$this->_params[$key] = $value ;
		}
	}
	/**
	 * Process Payment
	 *
	 */
	function processPayment($row, $data) {
		global $mainframe, $Itemid ;		
		require_once JPATH_COMPONENT.DS.'payments'.DS.'fddirect'.DS.'lphp.php';
		$mylphp=new lphp;
						
		$this->setParam('chargetotal', round($data['gateway_amount'], 2));			
		$this->setParam('cardnumber', $data['x_card_num']) ;
		$this->setParam('cardexpmonth', str_pad($data['exp_month'], 2, '0', STR_PAD_LEFT)) ;
		$this->setParam('cardexpyear', substr($data['exp_year'], 2, 2)) ;
		$this->setParam('cvmvalue', $data['x_card_code']) ;

		//Billing information
		
		$this->setParam('name', $row->first_name.' '.$row->last_name) ;
		$this->setParam('company', $row->organization) ;
		$this->setParam('address1', $row->address) ;
		$this->setParam('address2', $row->address2) ;
		$this->setParam('city', $row->city) ;
		$this->setParam('state', $row->state) ;
		$this->setParam('country', $row->country) ;
		$this->setParam('phone', $row->phone) ;
		$this->setParam('fax', $row->fax) ;
		$this->setParam('email', $row->email) ;
		$this->setParam('zip', $row->zip) ;
		$this->setParam('comments', $row->comment) ;
		
		$result = $mylphp->curl_process($this->_params);  # use curl methods
		
		if ($result["r_approved"] != "APPROVED")	// transaction failed, print the reason
		{
			
			$_SESSION['reason'] = $result['r_error'] ;        	        
        	$mainframe->redirect(JRoute::_('index.php?option=com_jdonation&view=failure&id='.$row->id.'&Itemid='.$Itemid));        	       	        	        	
        	return false;			
		}
		else
		{					// success
			$config  = JoomDonationHelper::getConfig() ;
        	$row->transaction_id = $result['r_ordernum'] ;        	
        	$row->payment_date =  date('Y-m-d H:i:s');
			$row->published = true;
			$row->store();						
			JoomDonationHelper::sendEmails($row, $config);	   			
			JPluginHelper::importPlugin( 'jdonation' );
			$dispatcher =& JDispatcher::getInstance();
			$dispatcher->trigger( 'onAfterPaymentSuccess', array($row));
			$mainframe->redirect(JRoute::_('index.php?option=com_jdonation&view=complete&id='.$row->id.'&Itemid='.$Itemid));      	        	        	        
        	return true;			
		}
	}	
	/**
	 * Recurring payment for Joom Donation
	 *
	 */
	function processRecurringPayment($row, $data) {
		global $mainframe , $Itemid ;
		require_once JPATH_COMPONENT.DS.'payments'.DS.'fddirect'.DS.'lphp.php';
		$mylphp=new lphp;
		$config =  JoomDonationHelper::getConfig() ;		
		switch ($row->r_frequency) {
			case 'd':
				$length = 1 ;
				$unit = 'd';
				break ;
			case 'w' :
				$length = 1 ;
				$unit = 'w';
				break ;
			case 'm' :
				$length = 1 ;
				$unit = 'm' ;
				break ;
			case 'q' :
				$length = 3 ;
				$unit = 'm' ;
				break ;
			case 's' :
				$length = 6 ;
				$unit = 'm' ;
				break ;
			case 'a' :
				$length = 1 ;
				$unit = 'y';
				break ;					
		}
		//General transaction parameter
		$this->setParam('chargetotal', round($data['gateway_amount'], 2));			
		$this->setParam('cardnumber', $data['x_card_num']) ;
		$this->setParam('cardexpmonth', str_pad($data['exp_month'], 2, '0', STR_PAD_LEFT)) ;
		$this->setParam('cardexpyear', substr($data['exp_year'], 2, 2)) ;
		$this->setParam('cvmvalue', $data['x_card_code']) ;

		//Billing information
		
		$this->setParam('name', $row->first_name.' '.$row->last_name) ;
		$this->setParam('company', $row->organization) ;
		$this->setParam('address1', $row->address) ;
		$this->setParam('address2', $row->address2) ;
		$this->setParam('city', $row->city) ;
		$this->setParam('state', $row->state) ;
		$this->setParam('country', $row->country) ;
		$this->setParam('phone', $row->phone) ;
		$this->setParam('fax', $row->fax) ;
		$this->setParam('email', $row->email) ;
		$this->setParam('zip', $row->zip) ;
		$this->setParam('comments', $row->comment) ;
		//Recurring transaction parameter
		$this->setParam('startdate', date('Ymd', strtotime("+1 day"))) ; 
		$this->setParam('periodicity', $unit.$length) ;
		if ($data['r_times'] >= 2) {
			$this->setParam('installments', $data['r_times']) ;
		} else {
		    $this->setParam('installments', 999) ;
		}															
		$this->setParam('threshold', 2) ;
		$result = $mylphp->curl_process($this->_params);  # use curl methods
		
		if ($result["r_approved"] != "APPROVED")	// transaction failed, print the reason
		{
			
			$_SESSION['reason'] = $result['r_error'] ;        	        
        	$mainframe->redirect(JRoute::_('index.php?option=com_jdonation&view=failure&id='.$row->id.'&Itemid='.$Itemid));        	       	        	        	
        	return false;			
		}
		else
		{					// success
			$config  = JoomDonationHelper::getConfig() ;
        	$row->transaction_id = $result['r_ordernum'] ;        	
        	$row->payment_date =  date('Y-m-d H:i:s');
			$row->published = true;
			$row->payment_made = 1 ;
			$row->store();						
			JoomDonationHelper::sendEmails($row, $config);	   			
			JPluginHelper::importPlugin( 'jdonation' );
			$dispatcher =& JDispatcher::getInstance();
			$dispatcher->trigger( 'onAfterPaymentSuccess', array($row));
			$mainframe->redirect(JRoute::_('index.php?option=com_jdonation&view=complete&id='.$row->id.'&Itemid='.$Itemid));      	        	        	        
        	return true;			
		}
		
	}		
}