<?php
/**
 * @version		1.0
 * @package		Joomla
 * @subpackage	Event Booking
 * @author  	Luiz Felipe Weber
 * @copyright	Copyright (C) 2013 Weber TI
 * @license		GNU/GPL, see LICENSE.php
 */
// no direct access
defined( '_JEXEC' ) or die ;

class os_jboleto extends os_payment {
	/**
	 * Paypal mode 
	 *
	 * @var boolean live mode : true, test mode : false
	 */
	var $_mode = 0 ;
	/**
	 * Paypal url
	 *
	 * @var string
	 */
	var $_url = null ;
	/**
	 * Array of params will be posted to server
	 *
	 * @var string
	 */
	var $_params = array();
	/**
	 * Array containing data posted from paypal to our server
	 *
	 * @var array
	 */
	var $_data = array();
	/**
	 * Constructor functions, init some parameter
	 *
	 * @param object $config
	 */
	function os_jboleto($params) {
		parent::setName('os_jboleto');
		parent::os_payment();						
		parent::setCreditCard(false);
    	parent::setCardType(false);
    	parent::setCardCvv(false);
    	parent::setCardHolderName(false);
    	/**
    	 * @todo here
    	*/
    	$this->ipn_log = true ;
		$this->ipn_log_file = JPATH_COMPONENT.DS.'ipn_logs.txt';

		// arquivo do banco de dados
		$this->setParam('banco_id', $params->get('banco_id'));	

    	/*		
		$this->_mode = $params->get('paypal_mode') ;
		if ($this->_mode)
			$this->_url = 'https://www.paypal.com/cgi-bin/webscr';
		else
			$this->_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
		$this->setParam('business', $params->get('paypal_id'));	
		$this->setParam('rm', 2);
		$this->setParam('cmd', '_xclick');		
		$this->setParam('no_shipping', 1);
		$this->setParam('no_note', 1);
		$this->setParam('lc', 'US');
		$this->setParam('currency_code', $params->get('paypal_currency', 'USD'));
		*/
	}
	/**
	 * Set param value
	 *
	 * @param string $name
	 * @param string $val
	 */
	function setParam($name, $val) {
		$this->_params[$name] = $val;
	}
	/**
	 * Setup payment parameter
	 *
	 * @param array $params
	 */
	function setParams($params) {
		foreach ($params as $key => $value) {
			$this->_params[$key] = $value ;
		}
	}
	/**
	 * Process Payment
	 *
	 * @param object $row
	 * @param array $params
	 */
	function processPayment($row, $data) {
		$Itemid = JRequest::getInt('Itemid');		
		$siteUrl = JURI::base() ;

		/**
		 ***********************
		 * Componente J!Boleto
		 ***********************
		 */
        $app = JFactory::getApplication();
		// carregar boleto do banco de dados
		if (!class_exists('JboletoHelper')) {
			include_once JPATH_ROOT."/components/com_jboleto/constants.php";
		}

		$dados_boleto = array();
		$postData = JRequest::getVar('form');

		$id_pedido 						= $row->id;
		$dados_boleto['published'] 		= 1;
		$dados_boleto['idconfiguracao'] = $this->_params['banco_id']; // refazer aqui o codigo do banco
		$dados_boleto['source']	 		= 'Event Booking'; // refazer aqui o codigo do banco
		$dados_boleto['nosso_numero'] 	= $id_pedido;
		$dados_boleto['valor_total'] 	= round($data['amount'], 2);
		$dados_boleto['quantidade'] 	= $row->number_registrants;
		$dados_boleto['aceite'] 		= '';
		$dados_boleto['especie']		= 'R$';
		$dados_boleto['especie_doc']	= 'DS';

		// DADOS DO USUÁRIO
		$user =& JFactory::getUser();
		$dados_boleto['sacado']			= $row->first_name.' '.$row->last_name;
		$dados_boleto['usuario_joomla'] = $user->id;
		$dados_boleto['email'] 			= $row->email;
		$dados_boleto['cpf'] 			= $data['eb_cpf'];
		$dados_boleto['cep'] 			= $row->zip;
		$dados_boleto['endereco1'] 		= $row->address;
		$dados_boleto['cidade'] 		= $row->city;
		$dados_boleto['estado']	 		= $row->state;
		$demonstrativo_1 = "Inscrição - Evento: ".$data['event_title'];
		$dados_boleto['demonstrativo_1']= $demonstrativo_1;

		// nome do evento e participantes
		$demonstrativo2 = "Número da Inscrição: ".$id_pedido;
		$dados_boleto['demonstrativo_2']= $demonstrativo2;

		$jboleto = JboletoHelper::geraBoleto($dados_boleto);
		$params = &JComponentHelper::getParams( 'com_jboleto' );
		$show_msg = $params->get('show_msg');
		if ($jboleto) {
			if ($show_msg)
				$app->enqueueMessage('Boleto gerado com sucesso.');
		} else {
			if ($show_msg)
				$app->enqueueMessage('Erro ao gerar boleto.');
		}
		// gera o boleto 
		$botao_pagamento = JboletoHelper::linkBoleto(null, $id_pedido, '_blank');

		echo '<h1>Boleto - Inscrição - '.$data['event_title'].'</h1><br/>';
		echo '<p>Clique no link abaixo para imprimir seu boleto:</p>';
		echo $botao_pagamento;

		// envia os emails de confirmação de registro
		$config = EventBookingHelper::getConfig() ;		
		EventBookingHelper::sendEmails($row, $config);
	}

	/**
	 * Validate the post data from paypal to our server
	 *
	 * @return string
	 */
	function _validate() {
		
	}
	/**
	 * Log IPN result
	 *
	 * @param string $success
	 */
	function log_ipn_results($success) {
      if (!$this->ipn_log) return;
      $text = '['.date('m/d/Y g:i A').'] - '; 
      if ($success) $text .= "SUCCESS!\n";
      	else $text .= 'FAIL: '.$this->last_error."\n"; 
      $text .= "IPN POST Vars from jboleto:\n";
      foreach ($this->_data as $key=>$value) {
         $text .= "$key=$value, ";
      }
      $text .= "\nIPN Response from Jboleto:\n ".$this->ipn_response;
      $fp=fopen($this->ipn_log_file,'a');
      fwrite($fp, $text . "\n\n"); 
      fclose($fp);  // close file
   }
	/**
	 * Process payment 
	 *
	 */
	function verifyPayment() {
		 
	}		
}