<?php
/**
 * @version		1.6.2
 * @package		Joomla
 * @subpackage	Event Booking
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

if (!function_exists('BuildCategorytree')) 
{
	function buildMenu($parent = 0, $level = 0, $params, $currentCat = null) 
	{
		$menuClass = $params->get('menuclass_sfx');
		$levelStart = (int) $params->get('level_start',0);
		$levelEnd = (int) $params->get('level_end',0);
		$showAllChildren = (int) $params->get('showAllChildren',1);
		$showNumberEvent = (int) $params->get('number_event', 1);
		$itemId = (int) $params->get('item_id');
		if (!$itemId)		
			$itemId = EventBookingHelper::getItemid();	
		if ( (!$levelEnd || $level < $levelEnd) && $rows = modEbCategoriesHelper::getCategories($parent, $params) ) 
		{
			if ($level >= $levelStart) : ?>
				<ul class="level<?php echo $level . $menuClass ?> accordion">
					<?php endif;
					foreach( $rows as $row ) 
					{
						$totalEvent =  modEbCategoriesHelper::countEvents($row->category_id);
						($showNumberEvent) ? $total = '('.$totalEvent.')' : $total = '';
						if ($level >= $levelStart) 
						{
							$totalSub = modEbCategoriesHelper::getChildCategory($row->category_id);
							if($totalSub)
							{
								$class = 'not-empty';
							}
							else 
							{
								$class = 'empty';
							}
							$link = JRoute::_(EventbookingHelperRoute::getCategoryRoute($row->category_id, $itemId));
							?>
							<li <?php echo ($currentCat == $row->category_id ? ' id="current"' : '') ?>><a href="<?php echo $link; ?>" class="level<?php echo $level . $menuClass . ($currentCat == $row->category_id ? ' active' : '') ?>" target="_self"><?php echo htmlspecialchars(stripslashes($row->category_name), ENT_COMPAT, 'UTF-8') ?> <?php echo $total?></a>
							<span class="<?php echo $class; ?>"></span>
		                <?php
						}
							if($showAllChildren) :
								buildMenu($row->category_id, $level + 1, $params, $currentCat);
							endif;
								if ($level >= $levelStart) : ?>
		                    </li>
		                <?php
		                endif;
					} // end foreach
					if ($level >= $levelStart) : ?>
	            </ul>
			<?php
            endif;
		}
	}
}
buildMenu(0, 0, $params);
?>
<script type="text/javascript">
	(function($){
		$(document).ready(function () {
			$('ul').accordion();
		});
	})(jQuery);
</script>
