<?php
/**
 * @version		$Id: helper.php 96 2011-08-11 06:59:32Z michel $
 * @copyright	Copyright (C) 2013 Open Source Matters, Inc. All rights reserved.
 * @license		
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class modEbCategoriesHelper
{
    static public function getCategories($parent_id = 0, $params) {
    	$db = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	$parentfilter = is_numeric($parent_id) ? "parent = ".(int)$parent_id : "";
    	$orderfilter  = $params->get('ordering', 'ordering');
    	$query->select('*, id AS category_id, name AS category_name')
    		  ->from('#__eb_categories')
    		  ->where('published = 1')
    		  ->where($parentfilter)
    		  ->order("$orderfilter ASC")
    	;
    	$db->setQuery($query);
    	return $db->loadObjectList();
    }
    /**
     * get child category
     *
     * int $id
     * @return unknown
     */
    static public function getChildCategory($id)
    {
    	$db = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	$query->select('COUNT(id)')->from('#__eb_categories')->where('parent='.(int)$id)->where('published=1');
    	$db->setQuery($query);
    	return $db->loadResult();
    }
    /**
     * get total events in category
     */
    static public function countEvents($categoryId)
    {
    	$db = JFactory::getDbo();
    	$query = $db->getQuery(true);
    	$query->select('COUNT(id)')->from('#__eb_event_categories')->where('category_id='.(int)$categoryId);
    	$db->setQuery($query);
    	return $db->loadResult();
    }
}