<?php
/**
 * @version		1.6.2
 * @package		Joomla
 * @subpackage	Event Booking
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 - 2013 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// no direct access
defined( '_JEXEC' ) or die ;

$headerText = JText::_('EB_MEMBER_REGISTRATION') ;
$headerText = str_replace('[EVENT_TITLE]', $this->eventTitle, $headerText) ;
$headerText = str_replace('[ATTENDER_NUMBER]', $this->currentMember, $headerText) ;
if ($this->config->use_https) {
	$url = JRoute::_('index.php?option=com_eventbooking&Itemid='.$this->Itemid, false, true);
} else {
	$url = JRoute::_('index.php?option=com_eventbooking&Itemid='.$this->Itemid, false);
}
?>
<div id="eb-group-member-page" class="eb-container row-fluid">
	<h1 class="eb_title"><?php echo $headerText; ?></h1>
	<?php     	
	if (strlen(strip_tags($this->message->{'member_information_form_message'.$this->fieldSuffix})))
	{
		$msg = $this->message->{'member_information_form_message'.$this->fieldSuffix};
	}
	else
	{
		$msg = $this->message->member_information_form_message;
	}			
	if (strlen($msg)) {					
	?>								
		<div class="eb-message"><?php echo $msg ; ?></div>							 															
	<?php	
	}	
	?>
	<form method="post" name="adminForm" id="adminForm" action="<?php echo $url; ?>" autocomplete="off" class="form form-horizontal">
		<div class="control-group">
	    	<label class="control-label" for="first_name">
	    		<?php echo  JText::_('EB_FIRST_NAME') ?><span class="required">*</span>
	    	</label>
			<div class="controls">      				
	      		<input type="text" class="input-large" name="first_name" id="first_name" value=""/>		
			</div>	
	  	</div>			  	
	  	<?php
		if ($this->config->gs_lastname) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="last_name">
		    		<?php echo  JText::_('EB_LAST_NAME') ?><?php if ($this->config->gr_lastname) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="last_name" id="last_name" value=""/>		
				</div>	
		  	</div>			
		<?php	
		}		
		if ($this->config->gs_organization) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="organization">
		    		<?php echo  JText::_('EB_ORGANIZATION'); ?><?php if ($this->config->gr_organization) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="organization" id="organization" value=""/>		
				</div>	
		  	</div>			
		<?php	
		}
		if ($this->config->gs_address) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="address">
		    		<?php echo  JText::_('EB_ADDRESS'); ?><?php if ($this->config->gr_address) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-xlarge" name="address" id="address" value=""/>		
				</div>	
		  	</div>			
		<?php	
		}
		
		if ($this->config->gs_address2) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="address2">
		    		<?php echo  JText::_('EB_ADDRESS2'); ?><?php if ($this->config->gr_address2) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-xlarge" name="address2" id="address2" value=""/>		
				</div>	
		  	</div>			
		<?php	
		}			
		if ($this->config->gs_city) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="city">
		    		<?php echo  JText::_('EB_CITY'); ?><?php if ($this->config->gr_city) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="city" id="city" value=""/>		
				</div>	
		  	</div>							
		<?php	
		}												
		if ($this->config->gs_country) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="country">
		    		<?php echo  JText::_('EB_COUNTRY'); ?><?php if ($this->config->gr_country) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<?php echo $this->lists['country_list']; ?>		
				</div>	
		  	</div>			
		<?php	
		}	
		if ($this->config->gs_state) {				
			if ($this->config->display_state_dropdown) {
			?>
			<div class="control-group">
		    	<label class="control-label" for="state">
		    		<?php echo  JText::_('EB_STATE'); ?><?php if ($this->config->gr_state) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<?php echo $this->lists['state'] ; ?>		
				</div>	
		  	</div>						
			<?php	
			} else {
			?>
			<div class="control-group">
		    	<label class="control-label" for="state">
		    		<?php echo  JText::_('EB_STATE'); ?><?php if ($this->config->gr_state) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="state" id="state" value="" />		
				</div>	
		  	</div>				
			<?php	
			}										
		}		
		if ($this->config->gs_zip) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="zip">
		    		<?php echo  JText::_('EB_ZIP'); ?><?php if ($this->config->gr_zip) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="zip" id="zip" value=""/>		
				</div>	
		  	</div>					
		<?php	
		}
		if ($this->config->gs_phone) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="phone">
		    		<?php echo  JText::_('EB_PHONE'); ?><?php if ($this->config->gr_phone) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="phone" id="phone" value=""/>		
				</div>	
		  	</div>					
		<?php
		}
		if ($this->config->gs_fax) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="fax">
		    		<?php echo  JText::_('EB_FAX'); ?><?php if ($this->config->gr_fax) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="fax" id="fax" value=""/>		
				</div>	
		  	</div>				
		<?php
		}	
		if ($this->config->gs_email) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="email">
		    		<?php
                        echo  JText::_('EB_EMAIL');
                        if ($this->config->gr_email)
                        {
                            echo '<span class="required">*</span>';
                        }
                    ?>
		    	</label>
				<div class="controls">      				
		      		<input type="text" class="input-large" name="email" id="email" value=""/>		
				</div>	
		  	</div>					
		<?php				
		}	
	
		if ($this->customField) 
		{
			$fields = $this->fieldsList;
			$fieldsOutput = $this->fieldsOutput;
			foreach ($fields as $field)
			{
                if ($field->depend_on_field_id)
                {
                    $masterFieldValues = (array)$this->fieldAssoc[$field->depend_on_field_id]->field_values;
                    $dependOnOptions = explode(',', $field->depend_on_options);
                    if (count(array_intersect($masterFieldValues, $dependOnOptions)))
                    {
                        $displayStyle = '';
                    }
                    else
                    {
                        $displayStyle = 'style="display:none"';
                    }
                }
                else
                {
                    $displayStyle = '';
                }
				switch ($field->field_type) {
					case FIELD_TYPE_HEADING :
						?>
							<div class="control-group" id="field_<?php echo $field->name; ?>" <?php echo $displayStyle; ?>>
								<label class="control-label"><?php echo JText::_($field->title) ; ?></label>
							</div>													
						<?php	
						break ;
					case FIELD_TYPE_MESSAGE :
						?>
						<div class="control-group" id="field_<?php echo $field->name; ?>" <?php echo $displayStyle; ?>>
							<?php echo $field->description ; ?>
						</div>							
						<?php						
						break ;
					default:
					?>
					<div class="control-group" id="field_<?php echo $field->name; ?>" <?php echo $displayStyle; ?>>
	    				<label class="control-label" for="<?php echo $field->name ; ?>">
	    					<?php echo JText::_($field->title); ?>
	    					<?php
		    					if ($field->required) {
		    						echo '<span class="required">*</span>' ;
		    					}
		    					if (strlen(trim($field->description))) {
		    					?>
	    								<p class="field_description"><?php echo $field->description ; ?></p>
	    							<?php	
	    							}	
		    					?>
	    				</label>
						<div class="controls">
			      			<?php echo $fieldsOutput[$field->name]; ?>			      						      			      		
			    		</div>	
	    			</div>    								
					<?php			
				}				
			}					
		}
		
		if ($this->config->gs_comment) {
		?>
			<div class="control-group">
		    	<label class="control-label" for="comment">
		    		<?php echo  JText::_('EB_COMMENT'); ?><?php if ($this->config->gr_comment) echo '<span class="required">*</span>'; ?>
		    	</label>
				<div class="controls">      				
		      		<textarea rows="7" cols="50" name="comment" id="comment" class="input-large"></textarea>		
				</div>	
		  	</div>			
		<?php	
		}						
		?>		
		
		<div class="form-actions">
			<input type="button" class="btn btn-primary" name="btnSubmit" value="<?php echo  JText::_('EB_NEXT') ;?>" onclick="checkData();">
            <img id="ajax-loading-animation" src="<?php echo JUri::base(true);?>/media/com_eventbooking/ajax-loadding-animation.gif" style="display: none;"/>
		</div>	  				
		<input type="hidden" name="Itemid" value="<?php echo $this->Itemid; ?>" />
		<input type="hidden" name="event_id" value="<?php echo $this->eventId ; ?>" />
		<input type="hidden" name="option" value="com_eventbooking" />	
		<input type="hidden" name="number_registrants" value="<?php echo $this->numberRegistrants; ?>" />
		<input type="hidden" name="task" value="group_member" />					
		<input type="hidden" name="group_id" value="<?php echo $this->groupId; ?>" />
		<script type="text/javascript">
            var siteUrl = "<?php echo EventbookingHelper::getSiteUrl(); ?>";
			<?php 
				if ($this->config->display_state_dropdown) {
					echo $this->countryIdsString ;
					echo $this->countryNamesString ;				
					echo $this->stateString ;
				?>
					function updateStateList() {
						var form = document.adminForm ;
						//First of all, we need to empty the state dropdown
						var list = form.state ;
		
						// empty the list
						for (i = 1 ; i < list.options.length ; i++) {
							list.options[i] = null;
						}
						list.length = 1 ;
						var i = 0;
						//Get the country index
						var country = form.country.value ;			
						if (country != '') {
							//Find index of the country
							for (var i = 0 ; i < countryNames.length ; i++) {
								if (countryNames[i] == country) {						
									break ;
								}
							}
							//We will find the states
							var countryId = countryIds[i] ;				
							var stateNames = stateList[countryId]; ;
							if (stateNames) {
								var arrStates = stateNames.split(',');
								i = 1 ;
								var state = '';
								var stateName = '' ;
								for (var j = 0 ; j < arrStates.length ; j++) {
									state = arrStates[j] ;
									stateName = state.split(':');
									opt = new Option();
									opt.value = stateName[0];
									opt.text = stateName[1];
									list.options[i++] = opt;
								}
								list.lenght = i ;
							}								
						}					
					} 	
				<?php	
				}
			?>		
			function cancel() {
				location.href = 'index.php?option=com_eventbooking&Itemid=' + <?php echo $this->Itemid; ?> ;	
			}		
			function billingPage() {
				var form = document.adminForm ;
				form.task.value = 'group_billing';
				form.submit();
			}
			function checkData() {
				var form = document.adminForm ;
				if (form.first_name.value == '') {
					alert("<?php echo JText::_('EB_REQUIRE_FIRST_NAME'); ?>");
					form.first_name.focus();
					return ;
				}						
				<?php
					if ($this->config->gs_lastname && $this->config->gr_lastname) {
					?>
						if (form.last_name.value=="") {
							alert("<?php echo JText::_('EB_REQUIRE_LAST_NAME'); ?>");
							form.last_name.focus();
							return;
						}						
					<?php		
					}
					if ($this->config->gs_organization && $this->config->gr_organization) {
					?>
						if (form.organization.value=="") {
							alert("<?php echo JText::_('EB_REQUIRE_ORGANIZATION'); ?>");
							form.organization.focus();
							return;
						}						
					<?php		
					}
					if ($this->config->gs_address && $this->config->gr_address) {
					?>
						if (form.address.value=="") {
							alert("<?php echo JText::_('EB_REQUIRE_ADDRESS'); ?>");
							form.address.focus();
							return;	
						}						
					<?php		
					}
					if ($this->config->gs_city && $this->config->gr_city) {
					?>
						if (form.city.value == "") {
							alert("<?php echo JText::_('EB_REQUIRE_CITY'); ?>");
							form.city.focus();
							return;	
						}						
					<?php		
					}				
					if ($this->config->gs_state && $this->config->gr_state) {
						if ($this->config->display_state_dropdown) {
						?>
							if ((form.state.options.length > 1) && (form.state.value == '')) {
								alert("<?php echo JText::_('EB_REQUIRE_STATE'); ?>");
								form.state.focus();
								return;
							}
						<?php	
						} else {
						?>
							if (form.state.value =="") {
								alert("<?php echo JText::_('EB_REQUIRE_STATE'); ?>");
								form.state.focus();
								return;	
							}
						<?php	
						}																					
					}
					if ($this->config->gs_zip && $this->config->gr_zip) {
					?>
						if (form.zip.value == "") {
							alert("<?php echo JText::_('EB_REQUIRE_ZIP'); ?>");
							form.zip.focus();
							return;
						}						
					<?php		
					}
					if ($this->config->gs_country && $this->config->gr_country) {
					?>
						if (form.country.value == "") {
							alert("<?php echo JText::_('EB_REQUIRE_COUNTRY'); ?>");
							form.country.focus();
							return;	
						}				
					<?php		
					}
					if ($this->config->gs_phone && $this->config->gr_phone) {
					?>
						if (form.phone.value == "") {
							alert("<?php echo JText::_('EB_REQUIRE_PHONE'); ?>");
							form.phone.focus();
							return;
						}						
					<?php		
					}			
					if ($this->config->gs_email && $this->config->gr_email) {
					?>
						if (form.email.value == '') {
							alert("<?php echo JText::_('EB_REQUIRE_EMAIL'); ?>");
							form.email.focus();
							return;
						}							
						var emailFilter = /^\w+[\+\.\w-]*@([\w-]+\.)*\w+[\w-]*\.([a-z]{2,4}|\d+)$/i
						var ret = emailFilter.test(form.email.value);
						if (!ret) {
							alert('<?php echo  JText::_('EB_VALID_EMAIL'); ?>');
							form.email.focus();
							return;
						}
					<?php	
					}	
					if ($this->customField) {
						echo $this->customFieldValidation ;
					}
				?>																						
				form.submit();
			}		
			function checkNumber(txtName)
			{			
				var num = txtName.value			
				if(isNaN(num))			
				{			
					alert("<?php echo JText::_('EB_ONLY_NUMBER'); ?>");			
					txtName.value = "";			
					txtName.focus();			
				}			
			}								
		</script>	
		<?php echo JHtml::_( 'form.token' ); ?>
	</form>
</div>