<?php
/**
 * @version		1.6.2
 * @package		Joomla
 * @subpackage	Event Booking
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 - 2013 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// no direct access
defined( '_JEXEC' ) or die ;
JHtml::_('behavior.modal', 'a.eb-modal');
//Load greybox lib
$greyBox = JUri::base().'components/com_eventbooking/assets/js/greybox/';
$config = $this->config;
$nullDate = $this->nullDate;
$width = (int) $this->config->map_width ;
if (!$width)
{
    $width = 500 ;
}
$height = (int) $this->config->map_height ;
if (!$height)
{
    $height = 450 ;
}
?>
<script type="text/javascript">
    var GB_ROOT_DIR = "<?php echo $greyBox ; ?>";
</script>
<script type="text/javascript" src="<?php echo $greyBox; ?>AJS.js"></script>
<script type="text/javascript" src="<?php echo $greyBox; ?>AJS_fx.js"></script>
<script type="text/javascript" src="<?php echo $greyBox; ?>gb_scripts.js"></script>
<link href="<?php echo $greyBox; ?>gb_styles.css" rel="stylesheet" type="text/css" />
<div id="eb-events-archive-page" class="eb-container row-fluid">
<h1 class="eb-page-heading"><?php echo JText::_('EB_EVENTS_ARCHIVE'); ?></h1>
    <?php if(count($this->items)) { ?>
        <div id="eb-events">
        <?php
            for ($i = 0 , $n = count($this->items) ;  $i < $n ; $i++) {
                $event = $this->items[$i] ;
                $url = JRoute::_(EventbookingHelperRoute::getEventRoute($event->id, 0, $this->Itemid));
                ?>
                <div class="eb-event row-fluid">
                    <div class="eb-box-heading clearfix">
                        <h3 class="eb-event-title pull-left span11">
                            <a href="<?php echo $url; ?>" title="<?php echo $event->title; ?>" class="eb-event-title-link">
                                <?php echo $event->title; ?>
                            </a>
                        </h3>
                    </div>
                    <div class="eb-description">
                        <div class="row-fluid">
                            <div class="eb-description-details span7">
                                <?php
                                if ($event->thumb && file_exists(JPATH_ROOT.'/media/com_eventbooking/images/thumbs/'.$event->thumb)) {
                                ?>
                                    <a href="<?php echo JUri::base().'media/com_eventbooking/images/'.$event->thumb; ?>" class="eb-modal"><img src="<?php echo JUri::base().'media/com_eventbooking/images/thumbs/'.$event->thumb; ?>" class="eb-thumb-left"/></a>
                                <?php
                                }
                                //output event description
                                if (!$event->short_description)
                                {
                                    $event->short_description = $event->description ;
                                }
                                echo $event->short_description ;
                                ?>
                            </div>
                            <div class="span5">
                                <table class="table table-bordered table-striped">
                                    <tr class="eb-event-property">
                                        <td class="eb-event-property-label">
                                            <?php echo JText::_('EB_EVENT_DATE'); ?>:
                                        </td>
                                        <td class="eb-event-property-value">
                                            <?php
                                            if ($event->event_date == EB_TBC_DATE)
                                            {
                                                echo JText::_('EB_TBC');
                                            } else {
                                                echo JHtml::_('date', $event->event_date, $config->event_date_format, null) ;
                                            }
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                    if ($event->event_end_date != $nullDate)
                                    {
                                        ?>
                                        <tr class="eb-event-property">
                                            <td class="eb-event-property-label">
                                                <?php echo JText::_('EB_EVENT_END_DATE'); ?>:
                                            </td>
                                            <td class="eb-event-property-value">
                                                <?php echo JHtml::_('date', $event->event_end_date, $config->event_date_format, null) ; ?>
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    if ($event->cut_off_date != $nullDate)
                                    {
                                        ?>
                                        <tr class="eb-event-property">
                                            <td class="eb-event-property-label">
                                                <?php echo JText::_('EB_CUT_OFF_DATE'); ?>:
                                            </td>
                                            <td class="eb-event-property-value">
                                                <?php echo JHtml::_('date', $event->cut_off_date, $config->event_date_format, null) ; ?>
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    if ($config->show_capacity)
                                    {
                                        ?>
                                        <tr class="eb-event-property">
                                            <td class="eb-event-property-label">
                                                <?php echo JText::_('EB_CAPACTIY'); ?>:
                                            </td>
                                            <td class="eb-event-property-value">
                                                <?php
                                                if ($event->event_capacity)
                                                {
                                                    echo $event->event_capacity ;
                                                }
                                                else
                                                {
                                                    echo JText::_('EB_UNLIMITED') ;
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    if ($config->show_registered) {
                                        ?>
                                        <tr class="eb-event-property">
                                            <td class="eb-event-property-label">
                                                <?php echo JText::_('EB_REGISTERED'); ?>:
                                            </td>
                                            <td class="eb-event-property-value">
                                                <?php echo (int) $event->total_registrants ; ?>
                                                <?php
                                                if ($config->show_list_of_registrants && ($event->total_registrants > 0) && EventbookingHelper::canViewRegistrantList()) {
                                                    ?>
                                                    &nbsp;&nbsp;&nbsp;<a href="index.php?option=com_eventbooking&task=show_registrant_list&event_id=<?php echo $event->id ?>&tmpl=component" rel="gb_page_center[<?php echo VIEW_LIST_WIDTH; ?>, <?php echo VIEW_LIST_HEIGHT; ?>]" class="registrant_list_link"><span class="view_list"><?php echo JText::_("EB_VIEW_LIST"); ?></span></a>
                                                <?php
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    if ($config->show_available_place && $event->event_capacity) {
                                        ?>
                                        <tr class="eb-event-property">
                                            <td class="eb-event-property-label">
                                                <?php echo JText::_('EB_AVAILABLE_PLACE'); ?>:
                                            </td>
                                            <td class="eb-event-property-value">
                                                <?php echo $event->event_capacity - $event->total_registrants ; ?>
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    if (($event->individual_price > 0) || ($config->show_price_for_free_event)) {
                                        $showPrice = true ;
                                    } else {
                                        $showPrice = false ;
                                    }
                                    if ($config->show_discounted_price && ($event->individual_price != $event->discounted_price)) {
                                        if ($showPrice) {
                                            ?>
                                            <tr class="eb-event-property">
                                                <td class="eb-event-property-label">
                                                    <?php echo JText::_('EB_ORIGINAL_PRICE'); ?>:
                                                </td>
                                                <td class="eb-event-property-value">
                                                    <?php
                                                    if ($event->individual_price > 0) {
                                                        echo EventbookingHelper::formatCurrency($event->individual_price, $config, $event->currency_symbol);
                                                    }  else {
                                                        echo '<span class="eb_price">'.JText::_('EB_FREE').'</span>' ;
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                            <tr class="eb-event-property">
                                                <td class="eb-event-property-label">
                                                    <?php echo JText::_('EB_DISCOUNTED_PRICE'); ?>:
                                                </td>
                                                <td class="eb-event-property-value">
                                                    <?php
                                                    if ($event->discounted_price > 0) {
                                                        echo EventbookingHelper::formatCurrency($event->discounted_price, $config, $event->currency_symbol);
                                                    }  else {
                                                        echo '<span class="eb_price">'.JText::_('EB_FREE').'</span>' ;
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php
                                        }
                                    } else {
                                        if ($showPrice) {
                                            ?>
                                            <tr class="eb-event-property">
                                                <td class="eb-event-property-label">
                                                    <?php echo JText::_('EB_INDIVIDUAL_PRICE'); ?>:
                                                </td>
                                                <td class="eb-event-property-value">
                                                    <?php
                                                    if ($event->individual_price > 0) {
                                                        echo EventbookingHelper::formatCurrency($event->individual_price, $config, $event->currency_symbol);
                                                    }  else {
                                                        echo '<span class="eb_price">'.JText::_('EB_FREE').'</span>' ;
                                                    }
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php
                                        }
                                    }
                                    if (isset($event->paramData)) {
                                        foreach ($event->paramData as $paramItem) {
                                            if ($paramItem['value']) {
                                                ?>
                                                <tr class="eb-event-property">
                                                    <td class="eb-event-property-label">
                                                        <?php echo $paramItem['title']; ?>:
                                                    </td>
                                                    <td class="eb-event-property-value">
                                                        <?php
                                                        echo $paramItem['value'];
                                                        ?>
                                                    </td>
                                                </tr>
                                            <?php
                                            }
                                            ?>
                                        <?php
                                        }
                                    }
                                    if ($event->location_id && $config->show_location_in_category_view) {
                                    ?>
                                        <tr class="eb-event-property">
                                            <td class="eb-event-property-label">
                                                <strong><?php echo JText::_('EB_LOCATION'); ?>:</strong>
                                            </td>
                                            <td class="eb-event-property-value">
                                                <a href="<?php echo JRoute::_('index.php?option=com_eventbooking&task=view_map&location_id='.$event->location_id.'&tmpl=component&format=html'); ?>" rel="gb_page_center[<?php echo $width; ?>, <?php echo $height; ?>]" title="<?php echo $event->location_name ; ?>" class="location_link"><?php echo $event->location_name ; ?></a>
                                            </td>
                                        </tr>
                                    <?php
                                    }
                                    ?>
                                </table>
                            </div>
                        </div>
                        <div class="eb-taskbar clearfix">
                            <ul>
                                <li>
                                    <a class="btn btn-primary" href="<?php echo $url; ?>">
                                        <?php echo JText::_('EB_DETAILS'); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php
            }
            ?>
        </div>
        <?php
        if ($this->pagination->total > $this->pagination->limit)
        {
        ?>
            <div class="pagination">
                <?php echo $this->pagination->getPagesLinks(); ?>
            </div>
        <?php
        }
        ?>
    <?php
    }
    ?>
</div>