<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

// Get database connection
$db  = Factory::getDbo();
$app = Factory::getApplication();

// Get event_id from URL (?event_id=1)
$eventId = $app->input->getInt('event_id', 0);

// If no event_id, show a message
if (!$eventId) {
    echo "<p>No event selected. Please add ?event_id=1 to the URL.</p>";
    return;
}

// Query registrants
$query = $db->getQuery(true)
    ->select('*')
    ->from($db->quoteName('#__eb_registrants'))
    ->where($db->quoteName('event_id') . ' = ' . (int) $eventId);

$db->setQuery($query);
$registrants = $db->loadObjectList();

// If no registrants, show a message
if (!$registrants) {
    echo "<p>No registrants found for event ID {$eventId}.</p>";
    return;
}

$perPage = 6; // change to 4 if you want 4 per page
$count   = 0;
?>

<style>
.badge-page {
  width: 210mm; /* A4 width */
  height: 297mm; /* A4 height */
  display: flex;
  flex-wrap: wrap;
  page-break-after: always;
}
.badge {
  box-sizing: border-box;
  padding: 8mm;
  border: 1px solid #000;
  text-align: center;
  font-family: Arial, sans-serif;
}
.badge-4 {
  width: 50%; /* 2 per row */
  height: 50%; /* 2 rows per page */
}
.badge-6 {
  width: 33.3%; /* 3 per row */
  height: 50%; /* 2 rows per page */
}
.badge h2 {
  margin: 5px 0;
  font-size: 16pt;
}
.badge p {
  margin: 3px 0;
  font-size: 12pt;
}
.badge img {
  margin-top: 10px;
  max-width: 80px;
}
</style>

<?php foreach ($registrants as $registrant): ?>
  <?php if ($count % $perPage === 0): ?>
    <div class="badge-page">
  <?php endif; ?>

    <div class="badge <?php echo $perPage == 6 ? 'badge-6' : 'badge-4'; ?>">
      <h2><?php echo htmlspecialchars($registrant->first_name . ' ' . $registrant->last_name); ?></h2>
      <p><?php echo htmlspecialchars($registrant->organization); ?></p>
      <?php if (!empty($registrant->ticket_qrcode)): ?>
        <img src="https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=<?php echo urlencode($registrant->ticket_qrcode); ?>" alt="QR Code">
      <?php endif; ?>
    </div>

  <?php $count++; ?>
  <?php if ($count % $perPage === 0): ?>
    </div>
  <?php endif; ?>
<?php endforeach; ?>